#include <iostream>
#include <vector>
#include <queue>
using namespace std;

const int INF = 1e9;

int main() {
    int N;
    cin >> N;

    vector<vector<int>> graph(N + 1);
    for (int i = 0; i < N - 1; ++i) {
        int U, V;
        cin >> U >> V;
        graph[U].push_back(V);
        graph[V].push_back(U);
    }

    vector<int> platform(N + 1);
    for (int i = 1; i <= N; ++i) {
        cin >> platform[i];
    }

    vector<int> changes(N + 1);
    for (int i = 1; i <= N; ++i) {
        cin >> changes[i];
    }

    vector<int> jumps(N + 1, INF);
    jumps[1] = 0;

    queue<int> q;
    q.push(1);

    while (!q.empty()) {
        int room = q.front();
        q.pop();

        for (int nextRoom : graph[room]) {
            if (jumps[nextRoom] > jumps[room] + 1) {
                jumps[nextRoom] = jumps[room] + 1;
                q.push(nextRoom);
            }
        }

        int jumpTo = room + 1;
        while (jumpTo <= N && jumpTo <= room + changes[room] && (platform[jumpTo] || !changes[jumpTo])) {
            if (jumps[jumpTo] > jumps[room] + 1) {
                jumps[jumpTo] = jumps[room] + 1;
                q.push(jumpTo);
            }
            ++jumpTo;
        }
    }

    for (int i = 1; i <= N; ++i) {
        if (jumps[i] == INF) {
            cout << -1 << " ";
        } else {
            cout << jumps[i] << " ";
        }
    }
    cout << endl;

    return 0;
}